<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "vieclamtapvu.com - Website Tuyển Dụng Việc Làm Tạp Vụ Chất Lượng",
  "alternateName": "Việc làm tạp vụ",
  "url": "https://vieclamtapvu.com/",
  "logo": "https://vieclamtapvu.com/wp-content/uploads/elementor/thumbs/vieclamtapvu-qkijdc0jt72k44dxm9g24mtp4tft4kvft0wns2xwl0.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0886585693",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamtapvu",
    "https://www.youtube.com/channel/UCAjmQFAa1IsglZrtaEt151g",
    "https://twitter.com/vieclamtapvu",
    "https://www.linkedin.com/in/vieclamtapvu/",
    "https://infovieclam.blogspot.com",
    "https://www.pinterest.com/vieclamtapvu/",
    "https://vieclamtapvu.tumblr.com/",
    "https://www.blogger.com/profile/07092191350710913703"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "vieclamtapvu.com - Website Tuyển Dụng Việc Làm Tạp Vụ Chất Lượng",
  "image": "https://vieclamtapvu.com/wp-content/uploads/elementor/thumbs/vieclamtapvu-qkijdc0jt72k44dxm9g24mtp4tft4kvft0wns2xwl0.png",
  "@id": "https://vieclamtapvu.com/",
  "url": "https://vieclamtapvu.com/",
  "telephone": "0886585693",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "934C Đ. Tạ Quang Bửu, Phường 5, Quận 8, Thành phố Hồ Chí Minh 700000, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.7343387,
    "longitude": 106.6578107
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamtapvu",
    "https://www.youtube.com/channel/UCAjmQFAa1IsglZrtaEt151g",
    "https://twitter.com/vieclamtapvu",
    "https://www.linkedin.com/in/vieclamtapvu/",
    "https://infovieclam.blogspot.com",
    "https://www.pinterest.com/vieclamtapvu/",
    "https://vieclamtapvu.tumblr.com/",
    "https://www.blogger.com/profile/07092191350710913703"
  ] 
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Bùi Thanh Tùng",
  "url": "http://vieclamtapvu.com/author/admin/",
  "image": "https://top10sanpham.vn/wp-content/uploads/2023/02/chup-hinh-doanh-nhan-tphcm-12.jpg",
  "sameAs": [
    "https://sites.google.com/view/buithanhtung/",
    "https://www.youtube.com/channel/UCma4soX9590ZZ6hAWnppmMA/about",
    "https://twitter.com/ceobuithanhtung",
    "https://ceobuithanhtung.blogspot.com/",
    "https://www.pinterest.com/ceobuithanhtung/",
    "https://ceobuithanhtung.tumblr.com/",
    "https://www.blogger.com/profile/03471875841231517359",
    "https://flipboard.com/@ceobuithanhtung/"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "vieclamtapvu.com"
  }  
}
</script>

	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-0BTHGVNWV0"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-0BTHGVNWV0');
</script>
	<meta name='dmca-site-verification' content='MitONnN3NnBtOC83RVp2VU02K3pYcldLTGNIVkxVczUvbnNTNUZuLzVwST01' />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">